﻿using System.Collections.Generic;
using System.Net;

internal class EndpointStatusCheck
{

    public HttpResponseDetail GetUrl(string url)
    {
        HttpResponseDetail response = new HttpResponseDetail();

        try
        {
            WebRequestor.Get(url, "status-check");
        }
        catch (WebException we)
        {
            throw new EndpointUnavailableException($"Error attempting to connect to Url:{url}, message: {we.Message}");
        }

        return response;
    }

    public HttpResponseDetail GetUrl(string url, IDictionary<string, string> headers)
    {
        HttpResponseDetail response = new HttpResponseDetail();

        try
        {
            GetRequestorSpecialized.Get(url, headers);
        }
        catch (WebException we)
        {
            throw new EndpointUnavailableException($"Error attempting to connect to Url:{url}, message: {we.Message}");
        }

        return response;
    }
}
